// config: norepeat noautolaunch

#include "GetObjects.js"

function DoProject()
{
	var ui = moi.ui;

	// First get objects to project.

	var objectpicker = ui.createObjectPicker();
	objectpicker.allowCurves();
	objectpicker.allowPointObjects();
	if ( !GetObjects( objectpicker ) )
		return;

	var objects = objectpicker.objects;


	// Next get target objects to project on to.

	ui.beginUIUpdate();
	ui.hideUI( 'SelectObjectsPrompt' );
	ui.showUI( 'SelectTargetPrompt' );
	ui.showUI( 'Options' );
	ui.showUI( 'TargetOptions' );
	ui.endUIUpdate();
	
	objectpicker.resetAllow();
	objectpicker.allowBReps();
	objectpicker.allowFaces();
	objectpicker.allowCurves();
	
	function eventhandler( objpicker )
	{
		return objpicker.event == 'usecplane';
	}
		
	if ( !GetObjects( objectpicker, false, eventhandler ) )
		return;
	
	var factory = moi.command.createFactory( 'project' );
	factory.setInput( 0, objects );
	
	factory.disableUpdate( true );
	ui.bindUIToInput( 'deleteinputs', 'value', factory.getInput(5) );
	factory.disableUpdate( false );
	
	if ( objectpicker.event == 'usecplane' )
	{
		// If the 'usecplane' button was pushed, set the plane on the factory and finish now.
		var plane = moi.view.getCPlane();
		
		switch( ui.commandUI.cplaneside.value )
		{
			case 'front' : plane = plane.front(); break;
			case 'right' : plane = plane.right(); break;
		}
			
		factory.setInput( 6, plane );
		factory.commit();
		return;
	}	
	
	factory.setInput( 1, objectpicker.objects );
	factory.setDefaultDirection();

	var projectmode = ui.commandUI.projectmode.value;
	var done = false;

	factory.setInput( 2, projectmode );
	factory.update();

	// We'll do stuff until "done" is pushed.
	
	while ( !done )
	{
		if ( projectmode == 'direction' )
		{
			// If we're in direction mode, then pick 2 points which define a new direction.
		
			var pointpicker = ui.createPointPicker();
			var basept = null;

			for ( var i = 0; i < 2 && projectmode == 'direction' && !done; ++i )
			{
				if ( i == 0 )
				{
					// Set up the first point pick.
					ui.beginUIUpdate();
					ui.hideUI( 'SelectTargetPrompt' );
					ui.hideUI( 'TargetOptions' );
					ui.hideUI( 'AdjustOptionsPrompt' );
					ui.hideUI( 'DirectionEndPrompt' );
					ui.showUI( 'DirectionStartPrompt' );
					ui.showUI( 'ProjectOptions' );
					ui.endUIUpdate();
				}
				else
				{
					// Set up the second point pick.
					ui.beginUIUpdate();
					ui.hideUI( 'DirectionStartPrompt' );
					ui.showUI( 'DirectionEndPrompt' );
					ui.endUIUpdate();
					
					factory.setInput( 3, basept );
					pointpicker.bindResultPt( factory.getInput( 4 ) );
				}
								
				while ( 1 )
				{
					if ( !pointpicker.waitForEvent() )
						return;
						
					if ( pointpicker.event == 'finished' )
					{
						if ( i == 0 )
							basept = pointpicker.pt;
					
						break;
					}
						
					if ( pointpicker.event == 'done' )
					{
						done = true;
						break;
					}
						
					if ( pointpicker.event == 'projectmode' )
					{
						projectmode = ui.commandUI.projectmode.value;
						
						factory.setInput( 2, projectmode );
						factory.update();
						
						break;
					}
				}
			}
			
			ui.clearPickedPoints();
		}
		else
		{
			// In closest point mode, wait until 'done' is pushed, or until the mode is
			// switched to direction.
		
			ui.beginUIUpdate();
			ui.hideUI( 'SelectTargetPrompt' );
			ui.hideUI( 'TargetOptions' );
			ui.hideUI( 'DirectionStartPrompt' );
			ui.hideUI( 'DirectionEndPrompt' );
			ui.showUI( 'AdjustOptionsPrompt' );
			ui.showUI( 'ProjectOptions' );
			ui.endUIUpdate();
			
			var dialog = ui.commandDialog;
			
			while ( 1 )
			{
				if ( !dialog.waitForEvent() )
					return;
					
				if ( dialog.event == 'done' )
				{
					done = true;
					break;
				}
				
				if ( dialog.event == 'projectmode' )
				{
					projectmode = ui.commandUI.projectmode.value;
					
					factory.setInput( 2, projectmode );
					factory.update();
					
					break;
				}
			}
		}
	}
	
	factory.commit();
}

DoProject();
